//
//  SpotlightValueListsDemoWindowController.m
//  SimpleSearchApp
//
//  Created by ub on 23.07.09.
//  Copyright 2009 Udo Borkowski. All rights reserved.
//

#import "SpotlightValueListsDemoWindowController.h"


@implementation NSMetadataQuery (SpotlightValueListsDemoWindowControllerExtras)

// returns all NSMetadataQueryAttributeValueTuple objects with the
// kMDItemKind attribute
//
// (kMDItemKind must be a valueListAttribute of the query)
//
- (NSArray*) kinds;
{
	return [[self valueLists] objectForKey: (NSString*)kMDItemKind];
}
@end



@implementation SpotlightValueListsDemoWindowController

- (id)init
{
	if (![super initWithWindowNibName:@"SpotlightValueListsDemoWindow"]) {
		return nil;
	}
	
	[self.query setValueListAttributes: 
          [NSArray arrayWithObjects: (NSString*)kMDItemKind, nil]];

	// For binding support, the custom "kinds" value added to NSMetadataQuery 
	// is considered changed whenever the valueLists changed
	[NSMetadataQuery setKeys: [NSArray arrayWithObjects: @"valueLists", nil] 
		triggerChangeNotificationsForDependentKey:@"kinds"];

	return self;
}
@end
